% plot_fig_ref.m
%   script to plot the average PSNR of reconstructed reference frames
%   versus average compression ratio
%
% Written: Hao Fang
% Created: Mar. 2012
% Modified: Apr. 2013

clear all;
close all;
clc;

path(path, './Data');

f = {'akiyo_qcif', 'foreman_qcif', 'coastguard_qcif'};
LineSpec = {'-^', '--^', '-o', '--o', '-d', '--d'};

% PSNR versus Compression Ratio
figure('Position',[50 50 1200 750]);
hold all;
for ii = 1:length(f)
    filename = f{ii};
    load(sprintf('%s_noperm.mat', filename), 'Ave_PSNR_Ref', 'CR');
    plot(CR, Ave_PSNR_Ref, LineSpec{(ii-1)*2 + 1}, ...
        'LineWidth', 4, ...
        'MarkerSize', 12);
    load(sprintf('%s_zigzagperm.mat', filename), 'Ave_PSNR_Ref', 'CR');
    plot(CR, Ave_PSNR_Ref, LineSpec{ii*2}, ...
        'LineWidth', 4, ...
        'MarkerSize', 12);
end
grid on;
set(gca, 'FontSize', 20, ...
    'FontWeight', 'Bold'); 
xlabel('Compression Ratio', 'FontSize', 20, 'FontWeight', 'Bold');
ylabel('PSNR(dB)', 'FontSize', 20, 'FontWeight', 'Bold');
h_legend = legend('akiyo no permutation', 'akiyo zigzag-scan-based permutation', ...
       'foreman no permutation', 'foreman zigzag-scan-based permutation', ...
       'coastguard no permutation', 'coastguard zigzag-scan-based permutation',...
       'Location', 'NorthWest');
set(h_legend, 'FontSize', 15);
set(h_legend, 'FontWeight', 'Bold');